function P82_iii
% Problem 8.2 :	The growth/decay of population of animal species
% iii. What happens to x_n  when 2<r<3.

% make series of r between 2 and 3
r=2.10:0.10:2.90;
% Set initial population matrix 
x0=[0.1:0.1:0.9]';
% Set the population year
nf=100;
for j=1:length(r)
    % Set the normalized population matrix
    % row: different initial populatipon
    % column: population year n
    xn=zeros(length(x0),nf);
    % Calculate the quadratic recurrence equation 
    x=x0;
    for i=1:nf
        xn(:,i)=r(j)*x.*(1-x);
        x=xn(:,i);
    end
    xf(j)=mean(xn(:,end));
end
% Plot the normalized population for n
figure(1);

% Generate series 
r1=[2:0.01:3]; 
xf1=(r1-1)./r1;
%
h=plot(r,xf,'rs',r1,xf1,'b-');
set(h,'MarkerSize',6,'LineWidth',2);
set(gca,'Fontsize',15);
legend('\bfFinal Value of Population','\bf(r-1)/r', ...
    'Location','SouthEast');
grid on; axis tight;
    xlabel('\bfThe population at year (a.u.)');
    ylabel('\bfThe normalized population x_n (a.u.)');
    title('\bfThe Normalized Population for 2<r<3');
end